package com.smart.nfcreader;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.nfc.NfcManager;
import android.os.Bundle;
import android.widget.Toast;

import com.smart.nfcreader.nfc.INfcManager;

public class MainActivity extends AppCompatActivity implements INfcManager.ResolveNfc {

    protected INfcManager iNfcManager;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        iNfcManager = new INfcManager(this,getClass());
        iNfcManager.setResolveNfc(this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent != null && iNfcManager != null && iNfcManager.isEnable()) {
            iNfcManager.resolve(intent);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (iNfcManager != null && iNfcManager.isEnable()) {
            iNfcManager.registerDispatch(this);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (iNfcManager != null && iNfcManager.isEnable()) {
            iNfcManager.unRegisterDispatch(this);
        }
    }

    @Override
    public void onNfcResult(String address, String name) {
        Toast.makeText(this, "address - " + address + "\nname = " + name, Toast.LENGTH_SHORT).show();
    }
}